import { ITeam } from "data";
import Image from "next/image";
import Link from "next/link";
import React from "react";

const TeamMember: React.FC<{ member: ITeam }> = ({ member }) => {
  return (
    <article className="relative">
      <Link href={`/board/${member.id}`}>
        <div className="rounded-lg aspect-square overflow-hidden container relative group">
          <Image
            //   className="h-full w-full "
            src={`/team/${member.image}`}
            alt=""
            layout="fill"
            objectPosition={"center top"}
            className="rounded-lg object-cover transition-all duration-300 group-hover:scale-110 hover:rounded-lg"
          />
          <div className="absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center bg-gradient-to-t  from-[#5e312f] to-[#5e312f63] transform transition-all duration-250 translate-y-full group-hover:translate-y-0">
            <div className="relative h-16 w-16 mb-10">
              <Image src={"/favicon.png"} layout="fill" />
            </div>
            <h3 className="text-sm font-semibold sm:text-md md:text-xl">
              <span title={member.name}>
                <span className="text-secondary-dark">{member.name}</span>
              </span>
            </h3>
            <h3 className="text-sm font-semibold text-white sm:text-md md:text-xl ">
              <span>More info</span>
            </h3>
          </div>
        </div>
      </Link>

      <div className="mt-4 flex items-start justify-between">
        <div className="text-center w-full">
          <h3 className="font-semibold text-base md:text-xl">
            <Link href={"#."}>
              <a title="">
                <span className="text-primary-dark">{member.name}</span>
              </a>
            </Link>
          </h3>
          <h4>
            <span
              className="text-xs  sm:text-sm md:text-base block line-clamp-2"
              aria-hidden="true"
            >
              {member.profession}
            </span>
          </h4>
        </div>
      </div>
    </article>
  );
};

export default TeamMember;
