import Calendar from "components/shared/Calendar";
import { IEvent } from "data";
import { events } from "dummyData";
import Image from "next/image";
import Link from "next/link";
import Slider from "react-slick";

interface IProps {
  eventCard: {
    event: IEvent;
  };
}

export const EventCard: React.FC<IProps["eventCard"]> = ({ event }) => {
  return (
    <div className="flex flex-col gap-8">
      {/* card header */}
      {/* <div className="p-5 bg-secondary-light mx-4">
        <div className="flex gap-3">
          <Calendar />
          <div className="flex flex-col justify-center gap-1">
            <h4 className="text-primary-dark text-xl font-bold">
              Apprentice Training Report
            </h4>
            <p className="text-white text-md leading-5 font-semibold">
              A break down of the findings and how they affect your mentee
            </p>
          </div>
        </div>
      </div> */}
      {/* event */}
      <div className=" flex flex-col gap-2  pb-6 mx-4 bg-white relative">
        <Link href={`/events/${event.id}`}>
          <div className="relative h-64 w-full group overflow-hidden cursor-pointer">
            <Image
              src={event.image}
              //   alt="Leadership-Finding-the-Right-Balance-of-Empathy"
              layout="fill"
              objectFit="cover"
              objectPosition={"center center"}
            />
            <div className="absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center bg-gradient-to-t  from-[#5e312f] to-[#5e312f63] transform transition-all duration-250 translate-y-full group-hover:translate-y-0">
              <div className="relative h-16 w-16 mb-10">
                <Image src={"/favicon.png"} layout="fill" />
              </div>
              <h3 className="text-sm font-semibold text-white sm:text-md md:text-xl ">
                <span>More info</span>
              </h3>
            </div>
          </div>
        </Link>
        <div className="px-4 pt-3 flex flex-col gap-3">
          <div className="text-2xl text-gray-600 tracking-wide flex flex-col gap-2">
            <h3 className="text-gray-800 text-lg ">{event.venue}</h3>
            <span className="text-xl font-semibold inline-block leading-6 text-secondary-accent line-clamp-3">
              {event.title}
            </span>
          </div>
          <div className="text-primary-dark text-xl flex items-center gap-3 font-semibold -tracking-wide">
            Learn More{" "}
            <div className="relative h-8 w-3 flex items-center">
              <Image
                src={"/logom.png"}
                layout="fill"
                // objectFit="cover"
                // objectPosition={"center center"}
              />
            </div>
          </div>
        </div>

        {/* calendar */}
        <div className="absolute top-2 left-5">
          <Calendar
            className="bg-[#ffffff88]"
            day={event.date?.day}
            month={event?.date?.month}
            year={event?.date?.year}
          />
        </div>
      </div>
    </div>
  );
};

const EventsSection = () => {
  const settings = {
    dots: false,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 2000,
    pauseOnHover: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: false,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };
  return (
    <div className="pt-[4%] bg-accent-dark">
      <section className="min-h-[70vh] w-4/5 mx-auto flex flex-col gap-4 pb-14 ">
        <div className="flex items-center text-3xl gap-4 font-cmp font-semibold tracking-wider pb-[2%]">
          <h3 className="text-primary-dark text-5xl">Events</h3>
          <div className="flex items-center gap-3">
            <div className="relative h-12 w-4 flex items-center">
              <Image
                src={"/logom4.png"}
                layout="fill"
                // objectFit="cover"
                // objectPosition={"center center"}
              />
            </div>
            <Link href="/events">
              <a className="uppercase text-secondary-accent font-bold cursor-pointer">
                All Events
              </a>
            </Link>
          </div>
        </div>

        {/* slider */}
        <Slider {...settings} className="-mx-4">
          {events.map((event) => (
            <EventCard key={event.id.toString()} event={event} />
          ))}
        </Slider>
      </section>
    </div>
  );
};

export default EventsSection;
