import { IGallery } from "data";
import { gallery } from "dummyData";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import Slider from "react-slick";

import "slick-carousel/slick/slick-theme.css";
import "slick-carousel/slick/slick.css";

interface IProps {
  newsItem: IGallery;
}

export const NewsCard: React.FC<IProps> = ({ newsItem }) => {
  return (
    <div className=" flex flex-col gap-2  pb-6 mx-4">
                      <div className="relative h-64 w-full group overflow-hidden">

        {newsItem.type == 'video'?

                   <iframe
                   className="w-full h-full transform transition-all hover:scale-110 ease-out duration-700"
                   src={newsItem.image}
                   title={newsItem.subtitle}
                   frameBorder={0}
                   allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                   allowFullScreen
                 ></iframe>:
                 <>
          <Image
            src={newsItem.image}
            //   alt="Leadership-Finding-the-Right-Balance-of-Empathy"
            layout="fill"
            objectFit="cover"
            objectPosition={"center center"}
            className="transform transition-all hover:scale-110 ease-out duration-700"
          />
          <div className="absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center bg-gradient-to-t  from-[#5e312f] to-[#5e312f63] transform transition-all duration-250 translate-y-full group-hover:translate-y-0">
            <div className="relative h-16 w-16 mb-10">
              <Image src={"/favicon.png"} layout="fill" />
            </div>
            <h3 className="text-sm font-semibold text-white sm:text-md md:text-xl text-center p-5">
              {newsItem.subtitle}
            </h3>
    
        </div>
        </>
        }
        </div>

     
    </div>
  );
};

const GallerySection = () => {
  const settings = {
    dots: false,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 2000,
    pauseOnHover: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: false,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <section className="min-h-[70vh] w-4/5 mx-auto flex flex-col gap-4 pt-6 pb-14">
      <div className="flex flex-col sm:flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal pb-[2%]">
        <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
          The latest from MAVEN
        </h3>
        <div className="flex items-center gap-3">
          <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
            <Image src={"/logom4.png"} layout="fill" />
          </div>
          <Link href="/gallery">
            <a className="uppercase text-secondary-accent font-cmp text-2xl sm:text-4xl">
              Gallery
            </a>
          </Link>
        </div>
      </div>

      {/* News card */}
      <Slider {...settings} className="-mx-4">
        {gallery.map((newsItem) => (
          <NewsCard key={newsItem.id.toString()} newsItem={newsItem} />
        ))}
      </Slider>
    </section>
  );
};

export default GallerySection;
