import { IProgramme } from "data";
import { programmes } from "dummyData";
import Image from "next/image";
import Link from "next/link";
import Slider from "react-slick";

interface IProps {
  programme: IProgramme;
}

export const ProgrammeCard: React.FC<IProps> = ({ programme }) => {
  return (
    <Link href={programme.link ? programme.link : "#."}>
      <div className=" flex flex-col gap-2  pb-6 mx-4 bg-white">
        <div className="relative h-64 w-full group overflow-hidden">
          <Image
            src={programme.image}
            //   alt="Leadership-Finding-the-Right-Balance-of-Empathy"
            layout="fill"
            objectFit="cover"
            objectPosition={"center center"}
          />
          <div className="absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center bg-gradient-to-t  from-[#5e312f] to-[#5e312f63] transform transition-all duration-250 translate-y-full group-hover:translate-y-0">
            <div className="relative h-16 w-16 mb-10">
              <Image src={"/favicon.png"} layout="fill" />
            </div>
            <h3 className="text-sm font-semibold text-white sm:text-md md:text-xl ">
              <span>More info</span>
            </h3>
          </div>
        </div>
        <div className="px-4 py-1">
          <div className="text-2xl tracking-wide line-clamp-2">
            <span className="text-xl text-primary-dark font-bold tracking-tight uppercase">
              {programme.title}
            </span>{" "}
          </div>
          <div className="text-secondary-accent text-xl flex items-center gap-3 font-bold mt-3">
            Enrol Today{" "}
            <div className="relative h-8 w-3 flex items-center">
              <Image
                src={"/logom.png"}
                layout="fill"
                // objectFit="cover"
                // objectPosition={"center center"}
              />
            </div>
          </div>
        </div>
      </div>
    </Link>
  );
};

const ProgrammesSection = () => {
  const settings = {
    dots: false,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 2000,
    pauseOnHover: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: false,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <div className="pt-[4%]" id="programmesSection">
      <section className="min-h-[70vh] w-4/5 mx-auto flex flex-col gap-4 pb-14 ">
        <div className="flex flex-col sm:flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal pb-[2%]">
          <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
            Best Practice Programmes
          </h3>
          <div className="flex items-center gap-3">
            <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
              <Image src={"/logom4.png"} layout="fill" />
            </div>
            <Link href="/programmes">
              <a className="uppercase text-secondary-accent font-cmp text-2xl sm:text-4xl">
                All Programmes
              </a>
            </Link>
          </div>
        </div>
        <div className="pb-10">
          <h3 className="text-primary-dark text-lg sm:text-2xl">
            Our Mentors are trained to enable teens to identify, unlock and
            harness their strengths in order to realise vocations and careers.
          </h3>
          <h4 className="text-gray-800 text-sm sm:text-lg">
            We use well-researched practices and carry out regular monitoring
            and evaluation.
          </h4>
        </div>

        {/* News card */}
        <Slider {...settings} className="-mx-4">
          {programmes.map((programme) => (
            <ProgrammeCard
              key={programme.id.toString()}
              programme={programme}
            />
          ))}
        </Slider>
      </section>
    </div>
  );
};

export default ProgrammesSection;
