import Image from "next/image";

const VideoSection = () => {
  return (
    <div className="pt-[4%] bg-accent-dark">
      <section className="min-h-[70vh] w-4/5 mx-auto flex flex-col gap-4 pb-14 ">
        <div className="flex items-center text-3xl gap-4 font-cmp font-semibold tracking-wider pb-[2%]">
          <h3 className="text-primary-dark text-5xl">Videos</h3>
          <div className="flex items-center gap-3">
            <div className="relative h-12 w-4 flex items-center">
              <Image
                src={"/logom4.png"}
                layout="fill"
                // objectFit="cover"
                // objectPosition={"center center"}
              />
            </div>
            <a href="https://www.youtube.com/@mavenmentorship" className="uppercase text-secondary-accent" target="_blank">All Videos</a>
          </div>
        </div>

        {/* main */}
        <article className="flex flex-1 flex-col md:flex-row w-full gap-10 ">
          <div className="md:w-1/3 flex flex-col py-5 gap-10 text-xl text-primary-dark">
            <p className="font-semibold">
              Click this video to be redirected to our YouTube channel. Remember
              to Subscribe to the channel to always be updated on Maven
              Mentorship news
            </p>
            {/* <p>
              Lorem ipsum dolor, sit amet consectetur adipisicing elit. Sed,
              ratione. Lorem ipsum, dolor sit amet consectetur adipisicing elit.
              Iusto, minima dolor fugit eligendi ipsum fugiat officia cumque
              doloribus mollitia obcaecati.
            </p> */}
          </div>

          {/* video card */}
          <div className=" w-full md:w-[60%]">
            <div className="relative w-full h-[30vh] md:h-[80%]">
              {/* <Image
                layout="fill"
                src={"/youtubevidsection.jpg"}
                objectFit="cover"
              />
              <FaYoutube
                size={100}
                color="red"
                className=" absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2"
              /> */}
              <iframe
                className="w-full h-full"
                // width="1478"
                // height="517"
                src="https://www.youtube.com/embed/LTjHHwcNQxE"
                title="Introduction to Maven Mentorship by Co-Founder & Chairman Stephen Wandera"
                frameBorder={0}
                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                allowFullScreen
              ></iframe>
            </div>
            {/* <div className="flex flex-col md:flex-row md:items-center justify-between p-4 gap-5">
              <div>
                <h3 className="text-gray-800 font-semibold text-sm ">
                  8:00am to 10:00am Breakfast | At the SNDBX
                </h3>

                <h3 className="text-xl font-semibold leading-6 text-secondary-accent">
                  The in and outs of understanding a teenagers Perspective
                </h3>
              </div>

              <div className="text-primary-dark text-xl flex items-center gap-3 font-semibold tracking-tight md:w-[30%] sm:justify-end">
                <span>Watch Now</span>
                <div className="relative h-8 w-3 flex items-center">
                  <Image
                    src={"/logom.png"}
                    layout="fill"
                    // objectFit="cover"
                    // objectPosition={"center center"}
                  />
                </div>
              </div>
            </div> */}
          </div>
        </article>
      </section>
    </div>
  );
};

export default VideoSection;
