import { partners } from "dummyData";
import Image from "next/image";
import Link from "next/link";
import {
  FaFacebookF,
  FaInstagram,
  FaLinkedinIn,
  FaTiktok,
  FaTwitter,
} from "react-icons/fa";

const Footer = () => {
  return (
    <footer className="pt-[4%] bg-secondary-dark text-primary-dark">
      <section className="min-h-[70vh] w-4/5 mx-auto flex flex-col lg:flex-row gap-20 lg:gap-48 pb-14 ">
        {/* Our partners */}

        <div className="self-center md:self-start  lg:w-[18%] relative bg-white w-32 px-2">
          <h3 className="bg-primary-dark px-3 pb-1  text-white w-fit transform -translate-y-full">
            Our Partners
          </h3>
          <div className="flex flex-row">

          
          <div className="flex flex-col items-center w-full gap-2 py-2">
            {partners.map((partner) => (
              <div key={partner.id.toString()} className="relative w-32 h-20">
                <Image
                  src={`/${partner.image}`}
                  layout="fill"
                  objectFit="contain"
                />
              </div>
            ))}
          </div>

          <div className="hidden lg:block absolute top-[50%] right-0 transform -translate-y-1/2 translate-x-[105%]">
            <div className="relative w-32 h-80">
              <Image src="/logom4.png" layout="fill" />
            </div>
          </div>
          </div>
        </div>

        {/* navlinks */}
        <div className=" flex flex-col items-center sm:items-start justify-between w-full">
          <h3 className="text-2xl text-center sm:text-left sm:text-3xl  lg:text-4xl xl:text-5xl font-semibold">
            Excellence Continuity
          </h3>
          {/* links */}
          <nav className="flex flex-col items-center sm:flex-row gap-10 py-10 sm:items-center justify-between w-full lg:w-4/5 font-semibold -tracking-wide">
            <div>
              <h3 className="mb-4 text-xl">Information For</h3>
              <ul className="flex flex-col items-center sm:items-start">
                <li>
                  <Link href={"/news"}>
                    <a>News</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/programmes"}>
                    <a>Programmes</a>
                  </Link>
                </li>
                <li>
                  <Link href="/events">
                    <a>Events</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/partners"}>
                    <a>Partners</a>
                  </Link>
                </li>
              </ul>
            </div>

            {/* Useful Links */}
            <div>
              <h3 className="mb-4 text-xl">Useful Links</h3>
              <ul className="flex flex-col items-center sm:items-start">
                <li>
                  <Link href={"/news"}>
                    <a>News</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/programmes"}>
                    <a>Programmes</a>
                  </Link>
                </li>
                <li>
                  <Link href="/events">
                    <a>Events</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/partners"}>
                    <a>Partners</a>
                  </Link>
                </li>
              </ul>
            </div>

            {/* Resources */}
            <div>
              <h3 className="mb-4 text-xl">Resources</h3>
              <ul className="flex flex-col items-center sm:items-start">
                <li>
                  <Link href={"/news"}>
                    <a>News</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/programmes"}>
                    <a>Programmes</a>
                  </Link>
                </li>
                <li>
                  <Link href="/events">
                    <a>Events</a>
                  </Link>
                </li>
                <li>
                  <Link href={"/partners"}>
                    <a>Partners</a>
                  </Link>
                </li>
              </ul>
            </div>
          </nav>
          {/* socials */}
          <div className="flex gap-5 ">
            <Link href="https://www.linkedin.com/in/mavenmentorship">
              <FaLinkedinIn
                className="text-primary-dark cursor-pointer hover:animate-bounce"
                size={18}
              />
            </Link>
            <Link href="https://twitter.com/mavenmentorship">
              <FaTwitter
                className="text-primary-dark cursor-pointer hover:animate-bounce"
                size={18}
              />
            </Link>
            <Link href="https://www.instagram.com/mavenmentorship/">
              <FaInstagram
                className="text-primary-dark cursor-pointer hover:animate-bounce"
                size={18}
              />
            </Link>
            <Link href="https://www.facebook.com/mavenmentorship/">
              <FaFacebookF
                className="text-primary-dark cursor-pointer hover:animate-bounce"
                size={18}
              />
            </Link>
            <Link href="https://www.tiktok.com/@mavenmentor">
              <FaTiktok
                className="text-primary-dark cursor-pointer hover:animate-bounce"
                size={18}
              />
            </Link>

            {/* <FaYoutube className="text-secondary-dark" size={18} /> */}
            {/* <FaWhatsapp className="text-secondary-dark" size={18} /> */}
          </div>

          <div className="flex flex-col gap-6">
            <div className="w-full border border-primary-dark" />

            <div className="flex text-sm sm:text-lg space-x-2 sm:space-x-6 font-semibold">
              <h3>SiteMap</h3>
              <h3>Disclaimer</h3>
              <h3>Privacy</h3>
              <h3>Accessiblity</h3>
            </div>
          </div>
        </div>
      </section>
      <div className="bg-primary-dark py-5 text-white">
        <div className="w-4/5 mx-auto font-semibold text-sm">
          &copy; {new Date().getFullYear()} MAVENMENTOR by SUBURBANdevs (
          <span>
            <a href="tel:+254740726783">+254740726783</a>
          </span>
          ). All Rights Reserved.
        </div>
      </div>
    </footer>
  );
};

export default Footer;
