// <!-- Google tag (gtag.js) -->
// <script async src="https://www.googletagmanager.com/gtag/js?id=G-3J674JFJYN"></script>
// <script>
//   window.dataLayer = window.dataLayer || [];
//   function gtag(){dataLayer.push(arguments);}
//   gtag('js', new Date());

//   gtag('config', 'G-3J674JFJYN');
// </script>
import Image from "next/image";
import Link from "next/link";
import { useRouter } from "next/router";
import React, { ReactElement } from "react";
import {
  FaChevronDown,
  FaChevronUp,
  FaFacebookF,
  FaInstagram,
  FaLinkedinIn,
  FaSearch,
  FaTiktok,
  FaTimes,
  FaTwitter,
} from "react-icons/fa";

import { HiMenu } from "react-icons/hi";

const NavOne = () => {
  return (
    <nav className="h-[12vh] md:h-[6vh] flex items-center bg-primary-dark">
      <div className="flex flex-col md:flex-row gap-4 items-center justify-between w-4/5 mx-auto">
        <div className="flex gap-5 ">
          <Link href="https://www.linkedin.com/in/mavenmentorship">
            <FaLinkedinIn
              className="text-secondary-dark cursor-pointer hover:animate-bounce"
              size={18}
            />
          </Link>
          <Link href="https://twitter.com/mavenmentorship">
            <FaTwitter
              className="text-secondary-dark cursor-pointer hover:animate-bounce"
              size={18}
            />
          </Link>
          <Link href="https://www.instagram.com/mavenmentorship/">
            <FaInstagram
              className="text-secondary-dark cursor-pointer hover:animate-bounce"
              size={18}
            />
          </Link>
          <Link href="https://www.facebook.com/mavenmentorship/">
            <FaFacebookF
              className="text-secondary-dark cursor-pointer hover:animate-bounce"
              size={18}
            />
          </Link>
          <Link href="https://www.tiktok.com/@mavenmentor">
            <FaTiktok
              className="text-secondary-dark cursor-pointer hover:animate-bounce"
              size={18}
            />
          </Link>

          {/* <FaYoutube className="text-secondary-dark" size={18} /> */}
          {/* <FaWhatsapp className="text-secondary-dark" size={18} /> */}
        </div>
        <ul className="flex items-center gap-2 md:gap-5 text-secondary-dark tracking-wider font-medium">
          <li>
            <Link href="https://portal.mavenmentorship.org/login">
              <a>Log in</a>
            </Link>
          </li>
          <li>
            <Link href="/news">
              <a>News</a>
            </Link>
          </li>

          <li>
            <Link href="/mentor">
              <a>Mentor</a>
            </Link>
          </li>
          <li>
            <Link href="/mentee">
              <a>Mentee</a>
            </Link>
          </li>
          <li>
            <Link href="/contact">
              <a>Contact</a>
            </Link>
          </li>
        </ul>
      </div>
    </nav>
  );
};

const Header = () => {
  const router = useRouter();

  const [open, setOpen] = React.useState(false);

  React.useEffect(() => {
    const handleStart = () => {
      setOpen(false);
    };

    router.events.on("routeChangeStart", handleStart);
  }, [router]);

  const AccordionNav: React.FC<{
    children: ReactElement[] | ReactElement;
    title: string;
  }> = ({ children, title }) => {
    const [navOpen, setNavOpen] = React.useState(false);

    React.useEffect(() => {
      const handleStart = () => {
        setNavOpen(false);
      };

      router.events.on("routeChangeStart", handleStart);
    }, [router]);

    return (
      <>
        <div
          className={`${
            !navOpen && "border-b border-b-gray-200"
          } mx-3 p-3 px-5 flex items-center justify-between`}
          onClick={() => setNavOpen((prev) => !prev)}
        >
          <a className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer">
            {title}
          </a>
          {navOpen ? <FaChevronUp /> : <FaChevronDown />}
        </div>
        <ul
          className={`${
            !navOpen ? "hidden" : "pl-10 text-sm border-b border-b-gray-200"
          }`}
        >
          {children}
        </ul>
      </>
    );
  };

  return (
    <header className="sticky -top-[12vh] md:-top-[6vh] left-0 z-10">
      <NavOne />

      {/* nav2 */}
      <nav className=" bg-white ">
        <div className="flex justify-between w-[85%] sm:w-4/5  mx-auto text-primary-dark">
          {/* <div className="h-20 w-48 relative"> */}
          <Link href={"/"}>
            <Image
              src={"/sbs_logo.png"}
              // layout="responsive"
              width={199}
              height={80}
              // objectFit="cover"
              // objectPosition="center"
            />
          </Link>
          {/* </div> */}

          <div className="hidden xl:flex   gap-10 xl:gap-16">
            <ul className="flex gap-3 xl:gap-8 uppercase text-sm font-extrabold">
              <li className="relative h-full flex items-center group">
                <Link href="/">
                  <a className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer">
                    Home
                  </a>
                </Link>
              </li>
              <li className="relative h-full flex items-center group">
                <a
                  href="#."
                  className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer"
                >
                  about maven
                </a>
                <ul className="hidden absolute bg-secondary-dark z-10 px-6 py-4 font-normal group-hover:flex hover:flex flex-col gap-2 top-[100%] w-52">
                  <li>
                    <Link href={"/story"}>
                      <a>Our story</a>
                    </Link>
                  </li>
                  <li>
                    <a href="/maven-journey">The maven journey</a>
                  </li>
                  <li>
                    <Link href="/greatgoal">
                      <a>the great goal</a>
                    </Link>
                  </li>
                  <li>
                    <Link href="/gallery">
                      <a>Gallery</a>
                    </Link>
                  </li>
                </ul>
              </li>
              <li className="relative h-full flex items-center group">
                <Link href={"/mentorship-programmes"}>
                  <a
                    href="#."
                    className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer"
                  >
                    mentorship programmes
                  </a>
                </Link>

                {/* <ul className="hidden absolute bg-secondary-dark z-10 px-6 py-4 font-normal group-hover:flex hover:flex flex-col gap-2 top-[100%] w-64">
                  <li>
                    <Link href={"/mentorship-programmes#outreach-programmes"}>
                      <a href="#.">Outreach Programmes</a>
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/mentorship-programmes#private-school-programmes"}
                    >
                      <a href="#.">Private school programmes</a>
                    </Link>
                  </li>
                  <li>
                    <Link href={"/mentorship-programmes#individual-programmes"}>
                      <a href="#.">Individual programmes</a>
                    </Link>
                  </li>
                </ul> */}
              </li>
              <li className="group h-full flex items-center">
                <Link href="/mentors-training">
                  <a className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer">
                    mentors training
                  </a>
                </Link>
              </li>
              <li className="group h-full flex items-center">
                <Link href="/partners">
                  <a className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer">
                    Partners
                  </a>
                </Link>
              </li>
              <li className="relative h-full flex items-center group">
                <a
                  href="#."
                  className="group-hover:border-b-4 border-b-secondary-accent  cursor-pointer"
                >
                  our team
                </a>
                <ul className="hidden absolute bg-secondary-dark z-10 px-6 py-4 font-normal group-hover:flex hover:flex flex-col gap-2 top-[100%] w-52">
                  <li>
                    <Link href={"/board"}>
                      <a>Board</a>
                    </Link>
                  </li>
                  <li>
                    <Link href={"/"}>
                      <a>Management</a>
                    </Link>
                  </li>
                </ul>
              </li>
            </ul>
            <FaSearch className="relative self-center" size={15} />
          </div>

          <div className="flex xl:hidden items-center gap-5">
            <FaSearch size={22} />
            {open ? (
              <FaTimes size={28} onClick={() => setOpen((prev) => !prev)} />
            ) : (
              <HiMenu size={28} onClick={() => setOpen((prev) => !prev)} />
            )}
          </div>
        </div>

        {/* Mobile Menu */}
        <ul
          className={`2xl:hidden ${
            !open
              ? "hidden"
              : "flex flex-col text-primary-dark uppercase font-semibold pt-5"
          }`}
        >
          <li className="border-b border-b-gray-200 mx-3 px-2">
            <Link href="/">
              <a className="h-full w-full block p-3">Home</a>
            </Link>
          </li>
          <li>
            <AccordionNav title="About Maven">
              <li className="border-b border-b-gray-100">
                <Link href="/story">
                  <a className="h-full w-full block py-3 ">Our story</a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href="/maven-journey">
                  <a className="h-full w-full block py-3 ">The Maven Journey</a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href="/greatgoal">
                  <a className="h-full w-full block py-3 ">The Great Goal</a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href="/gallery">
                  <a className="h-full w-full block py-3 ">Gallery</a>
                </Link>
              </li>
            </AccordionNav>
          </li>
          {/* <li>
            <AccordionNav title="Mentorship Programmes">
              <li className="border-b border-b-gray-100">
                <Link href={"/mentorship-programmes#outreach-programmes"}>
                  <a className="h-full w-full block py-3 ">
                    Outreach programmes
                  </a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href={"/mentorship-programmes#private-school-programmes"}>
                  <a className="h-full w-full block py-3 ">
                    Private Schools programmes
                  </a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href={"/mentorship-programmes#individual-programmes"}>
                  <a className="h-full w-full block py-3 ">
                    Individual programmes
                  </a>
                </Link>
              </li>
            </AccordionNav>
          </li> */}
          <li className="border-b border-b-gray-200 mx-3 px-2">
            <Link href="/mentorship-programmes">
              <a className="h-full w-full block p-3">Mentorship Programmes</a>
            </Link>
          </li>
          <li className="border-b border-b-gray-200 mx-3 px-2">
            <Link href="/mentors-training">
              <a className="h-full w-full block p-3">mentors training</a>
            </Link>
          </li>
          <li className="border-b border-b-gray-200 mx-3 px-2">
            <Link href="/partners">
              <a className="h-full w-full block p-3">partners</a>
            </Link>
          </li>

          <li>
            <AccordionNav title="Our Team">
              <li className="border-b border-b-gray-100">
                <Link href="/board">
                  <a className="h-full w-full block py-3 ">Board</a>
                </Link>
              </li>
              <li className="border-b border-b-gray-100">
                <Link href="#.">
                  <a className="h-full w-full block py-3 ">Management</a>
                </Link>
              </li>
            </AccordionNav>
          </li>
        </ul>
      </nav>
    </header>
  );
};

export default Header;
