import Head from "next/head";
import React from "react";
import Footer from "./Footer";
import Header from "./Header";

interface IProps {
  children: JSX.Element;
}

const Layout: React.FC<IProps> = ({ children }) => {
  return (
    <>
      <Head>
        <link rel="shortcut icon" href="/favicon.png" type="image/x-icon" />
        <title>Maven</title>
      </Head>
      <Header />
{/* <!-- Google tag (gtag.js) --> */}
{/* <script async src="https://www.googletagmanager.com/gtag/js?id=G-3J674JFJYN"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-3J674JFJYN');
</script> */}
      {children}

      <Footer />
    </>
  );
};

export default Layout;
