import { IDate } from "data";
import Image from "next/image";
import React from "react";
import Footer from "./Footer";
import Header from "./Header";

interface IProps {
  children: React.ReactNode | React.ReactNode[];
  image?: string;
  title: string;
  tag?: string | IDate;
  email?: string;
  buttonText?: string;
}

const LayoutThree: React.FC<IProps> = ({
  children,
  image,
  title,
  tag,
  email,
  buttonText,
}) => {
  const [caption, setCaption] = React.useState("Maven Mentorship");

  React.useEffect(() => {
    if (!tag) return;

    if (typeof tag === "object") {
      setCaption(Object.values(tag).join(" "));
      return;
    }

    setCaption(tag);
  }, [tag]);

  return (
    <>
      <Header />
      <div className="h-[70vh] relative w-full">
        <Image
          src={image ? image : "/team/teambg.jpg"}
          layout="fill"
          objectFit="cover"
          objectPosition="center top"
        />
        {/* <div className="absolute top-0 left-0 w-full h-full uppercase flex flex-col pl-[10%] justify-center font-bold text-4xl text-secondary-dark bg-[#5e312f63]"> */}
        <div className="absolute top-0 left-0 w-full h-full uppercase flex lg:flex-row flex-col pr-[10%] justify-center  lg:items-center lg:justify-between space-y-5 ">
          <div className="w-fit  bg-primary-dark pl-[10%] pr-[5%] py-10">
            <span className="text-accent-dark text-xl font-semibold">
              {caption}
            </span>
            <span className="font-bold text-4xl text-secondary-dark block">
              {title}
            </span>
          </div>
          <button className="rounded-lg bg-primary-dark w-fit p-3 ml-[10%] lg:ml-0">
            <a
              href={`mailto:${
                email ? email : "info@mavenmentorship.org"
              }?subject=${title ? title : "Maven Mentorship"}`}
              className="text-accent-dark text-xl font-semibold"
            >
              {buttonText ? buttonText : "Contact Us"}
            </a>
          </button>
        </div>
      </div>

      {/* <div className="relative bg-primary-dark py-3" />
      <div className="bg-secondary-dark py-6 relative" /> */}

      {children}

      <Footer />
    </>
  );
};

export default LayoutThree;
