import Image from "next/image";
import React from "react";
import Footer from "./Footer";
import Header from "./Header";

interface IProps {
  children: React.ReactNode | React.ReactNode[];
  image?: string;
  title: string;
  showIcon?: boolean;
  imgPosition?: string;
}

const LayoutTwo: React.FC<IProps> = ({
  children,
  image,
  title,
  showIcon,
  imgPosition,
}) => {
  return (
    <>
      <Header />
      <div className="h-[40vh] relative w-full">
        <Image
          src={image ? image : "/team/teambg.jpg"}
          layout="fill"
          objectFit="cover"
          objectPosition={imgPosition ? imgPosition : "center center"}
        />
        <div className="absolute bg-primary-dark top-0 left-0 w-full h-full uppercase flex flex-col  justify-center font-bold text-4xl text-secondary-dark bg-[#5e312f63]">
          {/* <div className="absolute top-0 left-0 w-full h-full uppercase flex flex-col items-center justify-center font-bold text-4xl text-secondary-dark"> */}
          <div className="w-fit  bg-primary-dark pl-[10%] pr-[5%] py-10">
            {showIcon && (
              <div className="relative h-16 w-[4.4rem] mb-10">
                <Image src={"/favicon.png"} layout="fill" />
              </div>
            )}
            <span>{title}</span>
          </div>
        </div>
      </div>

      {/* <div className="relative bg-primary-dark py-3" />
      <div className="bg-secondary-dark py-6 relative" /> */}

      {children}

      <Footer />
    </>
  );
};

export default LayoutTwo;
