const Calendar: React.FC<{
  day?: string;
  month?: string;
  year?: string;
  className?: string;
  invert?: boolean;
}> = ({ day, month, year, className, invert }) => {
  return (
    <div
      className={`calendar ${className} ${
        !invert ? "bg-white" : "bg-primary-dark"
      }`}
    >
      {day && (
        <span
          className={`inline-block ${
            invert ? "text-white" : "text-primary-dark"
          } text-xl font-black`}
        >
          {day}
        </span>
      )}
      {month && (
        <span
          className={`block uppercase font-black text-2xl  ${
            invert ? "text-white" : "text-primary-dark"
          } `}
        >
          {month}
        </span>
      )}
      {year && (
        <span
          className={`block uppercase font-black text-xl ${
            invert ? "text-white" : "text-primary-dark"
          }`}
        >
          {year}
        </span>
      )}
    </div>
  );
};

export default Calendar;
