import Image from "next/image";

const SlideFive = () => {
  return (
    <div>
      <div className="relative min-h-[80vh] lg:min-h-screen w-full">
        <Image
          src="/slide2.jpg"
          // width={1920}
          // height={1000}
          objectFit="cover"
          objectPosition={"center top"}
          // layout="responsive"
          layout="fill"
        />
        <div className="absolute top-0 left-0 h-full w-full">
          <div className="absolute bg-gradient-to-r  from-[#5e312f] to-[#5e312f63] top-1/2 transform -translate-y-1/2 w-[90%] lg:w-[85%] xl:w-[60%]">
            <p className="tracking-wider ml-[10%] text-xs sm:text-lg md:text-2xl md:leading-8 lg:text-4xl  font-medium text-white  lg:leading-tight p-2 space-y-2">
              <span className="block font-bold text-secondary-dark">
                We seek to understand and provide the African teen with a solid
                foundation for a productive life ahead...
              </span>
              <span className="block font-semibold">
                Our Mavens work to realign teen mentoring systems in Africa by
                falling back to the collective communal way of collaboratively
                preparing the youth for a fruitful future.
              </span>
              <span className="block font-bold text-secondary-dark">
                To Positively Impact Africa by empowering the teen mindset
              </span>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SlideFive;
