import Image from "next/image";

const SlideFour = () => {
  return (
    <div>
      <div className="relative min-h-[80vh] lg:min-h-screen w-full">
        <Image
          src="/s4.jpeg"
          // width={1920}
          // height={1000}
          objectFit="cover"
          objectPosition={"center bottom"}
          // layout="responsive"
          layout="fill"
        />
        <div className="absolute top-0 left-0 h-full w-full">
          <div className="h-full w-[80%] mx-auto flex items-center justify-center">
            <div>
              <div className="relative h-52 w-28 sm:w-[9rem] sm:h-[18rem] md:h-[20rem] md:w-[10rem] lg:h-[30rem] lg:w-[16rem] xl:h-[40rem] xl:w-[20rem]">
                <Image src={"/s1logo.png"} layout="fill" />
              </div>
            </div>

            <div className="flex flex-col gap-5 xl:gap-16 md:w-[70%] transform translate-y-[15%] lg:-translate-x-[6.5%] -translate-x-[5%]">
              <p className="text-sm sm:text-lg md:text-xl md:leading-8 lg:text-3xl  font-medium text-white lg:leading-tight p-2 pl-10">
                <span className="font-semibold text-secondary-dark">
                  The Maven’s sole purpose &nbsp;
                </span>
                is through volunteerism to provide a platform for teens from all
                walks of life to identify the promise within each and every one
                of them, and an opportunity to rise up to be mavens, to champion
                a seamless cycle of ever improving Excellence Continuity.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SlideFour;
