import Image from "next/image";

const SlideOne = () => {
  return (
    <div>
      <div className="relative min-h-[80vh] lg:min-h-screen w-full">
        <Image
          src="/s1.jpeg"
          // width={1920}
          // height={1000}
          objectFit="cover"
          objectPosition={"center"}
          // layout="responsive"
          layout="fill"
        />
        <div className="absolute top-0 left-0 h-full w-full">
          <div className="h-full w-[80%] mx-auto flex gap-6 items-center justify-center">
            <div>
              <div className="relative h-52 w-28 sm:w-[9rem] sm:h-[18rem] md:h-[20rem] md:w-[10rem] lg:h-[30rem] lg:w-[16rem] xl:h-[40rem] xl:w-[20rem]">
                <Image src={"/s1logo.png"} layout="fill" />
              </div>
            </div>

            <div className="flex flex-col gap-5 xl:gap-16 xl:w-[40%] md:w-[50%] xl:transform xl:translate-y-[30%] xl:-translate-x-[10%]">
              <h2 className="text-2xl sm:text-4xl lg:text-6xl ">
                <span className="block text-light-dark font-medium">The</span>
                <span className="block font-black text-4xl sm:text-6xl text-primary-dark">
                  Maven
                </span>
                <span className="block text-primary-dark font-semibold">
                  story
                </span>
              </h2>
              <p className="text-sm sm:text-lg lg:text-3xl italic font-medium text-white md:text-xl">
                Mentoring is a great tool used to shape and guide the youth on
                their journey to become responsible and productive members of
                the community. When powered by Voluntarism and targeted at the
                underprivileged the community can only develop.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SlideOne;
