import Image from "next/image";

const SlideSix = () => {
  return (
    <div>
      <div className="relative min-h-[80vh] lg:min-h-screen w-full">
        <Image
          src="/s6.jpeg"
          // width={1920}
          // height={1000}
          objectFit="cover"
          objectPosition={"center top"}
          // layout="responsive"
          layout="fill"
        />
        <div className="absolute top-0 left-0 h-full w-full">
          <div className="absolute bg-gradient-to-r top-1/2 left-1/2 transform -translate-y-2/3 -translate-x-1/2 w-[90%] lg:w-[85%] xl:w-[60%]">
            <p className="tracking-wider ml-[10%] text-xs sm:text-lg md:text-2xl md:leading-8 lg:text-4xl  font-medium text-white  lg:leading-tight p-2 flex flex-col gap-10">
              Maven is a pragmatic mentoring instrument designed to equip the
              care giver and the African teen (13-19 years) with self-belief,
              values and an opportunity to live life to the fullest now.
              <span className="block font-bold text-secondary-dark">
                Our Promise; Excellence Continuity
              </span>
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SlideSix;
