import Image from "next/image";

const SlideTwo = () => {
  return (
    <div>
      <div className="relative min-h-[80vh] lg:min-h-screen w-full">
        <Image
          src="/s2.jpeg"
          // width={1920}
          // height={1000}
          objectFit="cover"
          objectPosition={"center bottom"}
          // layout="responsive"
          layout="fill"
        />

        <div className="absolute top-0 left-0 h-full w-full">
          <div className="h-full w-[80%] mx-auto flex items-center justify-center">
            <div>
              <div className="relative h-52 w-28 sm:w-[9rem] sm:h-[18rem] md:h-[20rem] md:w-[10rem] lg:h-[30rem] lg:w-[16rem] xl:h-[40rem] xl:w-[20rem]">
                <Image src={"/s1logo.png"} layout="fill" />
              </div>
            </div>

            <div className="flex flex-col gap-5 xl:gap-16 md:w-[70%] transform translate-y-[30%] lg:-translate-x-[4.5%] -translate-x-[5%]">
              <p className="text-sm sm:text-lg md:text-2xl md:leading-8 lg:text-4xl  font-medium text-white bg-gradient-to-r  from-black to-accent-accent lg:leading-tight p-2 lg:py-10">
                The challenges and opportunities of the digital age have left a
                great many teens in Africa lost as they attempt to find a path
                to follow...
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SlideTwo;
