export interface IDate {
  day?: string;
  month?: string;
  year?: string;
}

export interface INewsContent {
  intro: string;
  list: string[];
  outro: string;
  listTitle?: string;
}

export interface INews {
  id: number;
  image: string;
  title: string;
  subtitle: string;
  datePosted: string;
  content: string | INewsContent;
  form?: string;
}
export interface IGallery {
  id: number;
  type: string;
  image: string;
  title: string;
  subtitle: string;
  datePosted: string;
  content: string | INewsContent;
  form?: string;
}

export interface IProgramme {
  id: number;
  image: string;
  title: string;
  subtitle?: string;
  datePosted?: string;
  link?: string;
}
export interface IEvent {
  id: number;
  image: string;
  date?: IDate;
  venue: string;
  title?: string;
  content?: string;
  email?: string;
  capacity?: number;
}

export interface IBio {
  intro: string;
  body: string;
  outro: string;
}

export interface ITeam {
  id: number;
  name: string;
  image: string;
  profession: string;
  bio: string | IBio;
  email: string;
}

export interface IParnerActivity {
  id: number;
  title: string;
}

export interface IMentorshipProgramme {
  id: number;
  title: string;
  intro: string;
  body: string;
  image: string;
}

export interface IPartner {
  id: number;
  name: string;
  image: string;
}
