import Layout from "components/layout/Layout";
import { NextPage } from "next";
import type { AppProps } from "next/app";
import Head from "next/head";
import { ReactElement, ReactNode } from "react";
import { ParallaxProvider } from "react-scroll-parallax";
import "../styles/globals.css";

export type NextPageWithLayout<P = {}, IP = P> = NextPage<P, IP> & {
  getLayout?: (page: ReactElement) => ReactNode;
};

type AppPropsWithLayout = AppProps & {
  Component: NextPageWithLayout;
};

function MyApp({ Component, pageProps }: AppPropsWithLayout) {
  const getLayout = Component.getLayout ?? ((page) => <Layout>{page}</Layout>);

  return (
    <ParallaxProvider>
      <div className="tracking-wide">
        <Head>
          <link rel="shortcut icon" href="/favicon.png" type="image/x-icon" />
        </Head>
        {getLayout(<Component {...pageProps} />)}
      </div>
    </ParallaxProvider>
  );
}

export default MyApp;
