import TeamMember from "components/board/TeamMember";
import LayoutTwo from "components/layout/LayoutTwo";
import { team } from "dummyData";
import { ReactElement } from "react";

const TeamPage = () => {
  return (
    <>
      <div className="bg-accent-dark ">
        <div className="mx-auto max-w-[80%]">
          <main className="grid grid-cols-1 gap-x-6 gap-y-10 px-2 pb-20 sm:grid-cols-2 p-8  lg:grid-cols-3 lg:gap-x-4 lg:px-0  xl:grid-cols-4 xl:gap-x-6">
            {team.map((teamMember) => (
              <TeamMember member={teamMember} key={teamMember.id.toString()} />
            ))}
          </main>
        </div>
      </div>
    </>
  );
};

export default TeamPage;

TeamPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo
      image={"/team/teambg.jpg"}
      title={"Board"}
      imgPosition="center center"
    >
      {page}
    </LayoutTwo>
  );
};
