import LayoutTwo from "components/layout/LayoutTwo";
import Image from "next/image";
import { ReactElement } from "react";
import { BsPeopleFill } from "react-icons/bs";
import { HiCalendar } from "react-icons/hi";
import { ImLocation2 } from "react-icons/im";

const ContactPage = () => {
  return (
    <main className="">
      <section className="w-[80%] mx-auto text-gray-600 body-font">
        <div className="container px-5 py-14 mx-auto">
          <div className="flex flex-col text-left w-full mb-20">
            {/* <h1 className="sm:text-3xl text-2xl font-medium title-font text-gray-900">
              We always here to help out whatever way we can.
            </h1> */}
            <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp  flex items-center gap-3 ">
              We are here to help you in whatever way we can
              <span className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
                <Image src={"/logom4.png"} layout="fill" />
              </span>
            </h3>
          </div>
          <div className="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3">
            {/* location */}
            <div className="p-4 col-auto ">
              <div className="flex rounded-lg h-full bg-gray-100 p-8 flex-col">
                <div className="flex  mb-3 flex-col 2xl:flex-row gap-2">
                  <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white mr-3 w-fit h-fit">
                    <ImLocation2 size={20} />
                  </div>
                  <div className="flex flex-col justify-center gap-1">
                    <h4 className="text-light-dark text-xl font-semibold ">
                      SNDBX, CMS Africa House Chania Avenue, (behind Yaya
                      Center), Nairobi.
                    </h4>
                    {/* <h5 className="text-light-accent text-base font-semibold  ">
                      P.O. Box 123434 - 00100, Nairobi, Kenya
                    </h5> */}
                  </div>
                </div>
              </div>
            </div>

            {/* phone */}
            <div className="p-4 col-auto">
              <div className="flex rounded-lg h-full bg-gray-100 p-8 flex-col">
                <div className="flex mb-3 flex-col 2xl:flex-row gap-2">
                  <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white mr-3  w-fit h-fit">
                    <HiCalendar size={20} />
                  </div>
                  <div className="flex flex-col justify-center gap-1">
                    <h4 className="text-light-dark text-xl font-semibold ">
                      Phone
                    </h4>
                    <h5 className="text-light-accent text-base font-semibold  ">
                      +254797352222
                    </h5>
                  </div>
                </div>
              </div>
            </div>

            {/* email */}
            <div className="p-2 xl:p-4 col-auto overflow-none">
              <div className="flex rounded-lg h-full bg-gray-100 p-8 flex-col">
                <div className="flex mb-3 flex-col 2xl:flex-row gap-2">
                  <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white mr-3  w-fit h-fit">
                    <BsPeopleFill size={20} />
                  </div>
                  <div className="flex flex-col justify-center gap-1">
                    <h4 className="text-light-dark text-xl font-semibold ">
                      Email
                    </h4>
                    <h5 className="text-light-accent  font-semibold  text-sm xl:text-base">
                      {/* {event.capacity} */}
                      <a href="mailto:info@mavenmentorship.org">
                        info@mavenmentorship.org
                      </a>
                    </h5>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* next section */}

      <section className="text-gray-600 body-font relative">
        <div className="container px-5 pb-24 mx-auto">
          <div className="lg:w-1/2 md:w-2/3 mx-auto">
            <form
              action="mailto:info@mavenmentorship.org?subject=Enquiry"
              method="post"
              encType="text/plain"
              className="flex flex-wrap -m-2"
            >
              <div className="p-2 w-1/2">
                <div className="relative">
                  <label
                    htmlFor="name"
                    className="leading-7 text-light-dark text-base font-semibold "
                  >
                    Name
                  </label>
                  <input
                    autoComplete="off"
                    type="text"
                    id="name"
                    name="name"
                    className="w-full bg-gray-100 bg-opacity-50 rounded border border-gray-300 focus:border-secondary-accent focus:bg-white focus:ring-2 focus:ring-indigo-200 text-base outline-none text-gray-700 py-1 px-3 leading-8 transition-colors duration-200 ease-in-out"
                  />
                </div>
              </div>
              <div className="p-2 w-1/2">
                <div className="relative">
                  <label
                    htmlFor="subject"
                    className="leading-7 text-light-dark text-base font-semibold "
                  >
                    Subject
                  </label>
                  <input
                    autoComplete="off"
                    type="text"
                    id="subject"
                    name="subject"
                    className="w-full bg-gray-100 bg-opacity-50 rounded border border-gray-300 focus:border-secondary-accent focus:bg-white focus:ring-2 focus:ring-indigo-200 text-base outline-none text-gray-700 py-1 px-3 leading-8 transition-colors duration-200 ease-in-out"
                  />
                </div>
              </div>
              <div className="p-2 w-full">
                <div className="relative">
                  <label
                    htmlFor="message"
                    className="leading-7 text-light-dark text-base font-semibold "
                  >
                    Message
                  </label>
                  <textarea
                    autoComplete="off"
                    id="message"
                    name="message"
                    className="w-full bg-gray-100 bg-opacity-50 rounded border border-gray-300 focus:border-secondary-accent focus:bg-white focus:ring-2 focus:ring-indigo-200 h-32 text-base outline-none text-gray-700 py-1 px-3 resize-none leading-6 transition-colors duration-200 ease-in-out"
                  ></textarea>
                </div>
              </div>
              <div className="p-2 w-full">
                <button
                  type="submit"
                  className="flex mx-auto text-white bg-primary-dark border-0 py-2 px-8 focus:outline-none  rounded text-lg font-semibold"
                >
                  Send
                </button>
              </div>
            </form>
          </div>
        </div>
      </section>
    </main>
  );
};

export default ContactPage;

ContactPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo image={"/contactbg.jpeg"} title={"Contact Us"}>
      {page}
    </LayoutTwo>
  );
};
