import { EventCard } from "components/home/EventsSection";
import LayoutTwo from "components/layout/LayoutTwo";
import { events } from "dummyData";
import { NextPageWithLayout } from "pages/_app";
import { ReactElement } from "react";

const EventsPage: NextPageWithLayout = () => {
  return (
    <div className="py-20 bg-accent-dark">
      <main className="w-[80%] mx-auto ">
        <div className="grid gap-x-8 gap-y-10 sm:grid-cols-2 lg:grid-cols-3">
          {events.map((event) => (
            <EventCard key={event.id.toString()} event={event} />
          ))}
        </div>
      </main>
    </div>
  );
};

export default EventsPage;

EventsPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo image="/events/eventsbg.jpeg" title="all events">
      {page}
    </LayoutTwo>
  );
};
