import { NewsCard } from "components/home/GallerySection";
import LayoutTwo from "components/layout/LayoutTwo";
import { gallery } from "dummyData";
import { NextPageWithLayout } from "pages/_app";
import { ReactElement } from "react";

const NewsPage: NextPageWithLayout = () => {
  return (
    <div className="py-20 bg-white">
      <main className="w-[80%] mx-auto ">
        <div className="grid gap-x-8 gap-y-10 sm:grid-cols-2 lg:grid-cols-3">
          {gallery.map((newsItem) => (
            <NewsCard key={newsItem.id.toString()} newsItem={newsItem} />
          ))}
        </div>
      </main>
    </div>
  );
};

export default NewsPage;

NewsPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo image="/news/newsbg.jpeg" title="Gallery">
      {page}
    </LayoutTwo>
  );
};
