import Image from "next/image";

const GreatGoalPage = () => {
  return (
    <div className="py-10 bg-accent-dark lg:bg-primary-dark">
      <div className="relative min-h-screen w-[80%] mx-auto bg-white rounded-2xl p-10 overflow-hidden my-20 hidden lg:block">
        <Image
          src="/greatgoal.jpg"
          objectPosition="center top"
          layout="fill"
          objectFit="cover"
          className="hidden"
        />

        <div className="absolute top-0 left-0 h-full w-full">
          <div className="absolute top-[45%] transform -translate-y-1/2 w-[90%] lg:w-[85%] xl:w-[60%] ">
            <div className="flex flex-col sm:flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal pl-10 pb-10">
              <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
                The Great Goal
              </h3>
              <div className="flex items-center gap-3">
                <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
                  <Image src={"/logom4.png"} layout="fill" />
                </div>
                {/* <Link href="#.">
                  <a className="uppercase text-secondary-accent font-cmp text-2xl sm:text-4xl">
                    More on the goal
                  </a>
                </Link> */}
              </div>
            </div>
            <section className="flex pl-10">
              <div className="flex flex-col gap-8 text-primary-dark">
                <div className="flex flex-col gap-1">
                  <h3 className="text-2xl font-bold">
                    For the Mentor an enormous sense of fulfillment is achieved
                    through successfully conducting and concluding the mentoring
                    relationship.{" "}
                  </h3>
                  <p className="text-xl font-semibold">
                    This satisfaction is considerably derived from realisation
                    of the dream that every mentee has innate potential of their
                    own.
                  </p>
                </div>
                <div className="flex flex-col gap-1">
                  <h3 className="text-2xl font-bold">
                    It is in the Mentee that we see the greatest and perhaps
                    most exciting transformation and empowerment.
                  </h3>
                  <p className="text-xl font-semibold">
                    The teen may have been foundering in lack of self-belief,
                    grinding poverty and hopelessness; through the Maven
                    mentorship programme they will now truly come into their
                    own.
                  </p>
                </div>
                <div className="flex flex-col gap-1">
                  <h3 className="text-2xl font-bold">
                    Here is indeed the manifestation of a modernized concept of
                    African community responsibility actively empowering the
                    teenage youth regardless of race, ethnicity, cultural
                    background or creed.
                  </h3>
                </div>
              </div>
            </section>
          </div>
        </div>
      </div>

      {/* smaller */}
      <div className=" h-full w-full lg:hidden">
        <div className=" w-[90%] lg:w-[85%] xl:w-[60%] ">
          <div className="flex flex-col sm:flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal pl-10 pb-10">
            <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
              The Great Goal
            </h3>
            <div className="flex items-center gap-3">
              <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
                <Image src={"/logom4.png"} layout="fill" />
              </div>
              {/* <Link href="#.">
                <a className="uppercase text-secondary-accent font-cmp text-2xl sm:text-4xl">
                  More on the goal
                </a>
              </Link> */}
            </div>
          </div>
          <section className="flex pl-10">
            <div className="flex flex-col gap-8 text-primary-dark">
              <div className="flex flex-col gap-1">
                <h3 className="text-2xl font-bold">
                  For the Mentor an enormous sense of fulfillment is achieved
                  through successfully conducting and concluding the mentoring
                  relationship.{" "}
                </h3>
                <p className="text-xl font-semibold">
                  This satisfaction is considerably derived from realisation of
                  the dream that every mentee has innate potential of their own.
                </p>
              </div>
              <div className="flex flex-col gap-1">
                <h3 className="text-2xl font-bold">
                  It is in the Mentee that we see the greatest and perhaps most
                  exciting transformation and empowerment.
                </h3>
                <p className="text-xl font-semibold">
                  The teen may have been foundering in lack of self-belief,
                  grinding poverty and hopelessness; through the Maven
                  mentorship programme they will now truly come into their own.
                </p>
              </div>
              <div className="flex flex-col gap-1">
                <h3 className="text-2xl font-bold">
                  Here is indeed the manifestation of a modernized concept of
                  African community responsibility actively empowering the
                  teenage youth regardless of race, ethnicity, cultural
                  background or creed.
                </h3>
              </div>
            </div>
          </section>
        </div>
      </div>
    </div>
  );
};

export default GreatGoalPage;
