import Image from "next/image";
import { MdLocationPin } from "react-icons/md";

import {
  VerticalTimeline,
  VerticalTimelineElement,
} from "react-vertical-timeline-component";
import "react-vertical-timeline-component/style.min.css";

const MavenJourneyPage = () => {
  return (
    <div className="py-10  bg-secondary-accent overflow-hidden">
      <main className="w-[80%] mx-auto">
        <div className="flex flex-col sm:flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal pb-10">
          <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
            The Maven Journey
          </h3>
          <div className="flex items-center gap-3">
            <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
              <Image src={"/logom.png"} layout="fill" />
            </div>
            {/* <Link href="#.">
              <a className="uppercase text-secondary-dark font-cmp text-2xl sm:text-4xl">
                More on the journey
              </a>
            </Link> */}
          </div>
        </div>
        <div className="px-4 pt-12 pb-8 hidden xl:block">
          <div className="mx-auto w-full  relative -my-[10%]">
            <div
              className="absolute left-0 top-1/2 h-0.5 w-full bg-secondary-dark"
              aria-hidden="true"
            />
            <ul className="w-full grid grid-cols-4 gap-2 h-max">
              <li className="text-left  grid grid-cols-1 place-items-center auto-rows-fr  text-secondary-dark">
                <MdLocationPin
                  size={100}
                  className=" transform translate-y-[260%]"
                />
                <div className="h-3 w-3  rounded-full bg-secondary-dark" />
                <div className="rounded  flex flex-col gap-2 my-20 transform -translate-y-[125%]">
                  <h3 className="text-xl font-semibold">Step 01</h3>
                  <p>
                    Using research-proven, global best practice we train our
                    Mentors who are themselves experts or Mavens in different
                    fields. The training rarely takes less than a full week.
                    Using this knowledge each Maven enters into a mentoring
                    relationship with a teen.
                  </p>
                </div>
              </li>
              <li className="text-left  grid grid-cols-1 place-items-center  auto-rows-fr text-accent-dark">
                <div className="rounded p-3 flex flex-col gap-2  transform translate-y-[125%]">
                  <p>
                    The journey is of necessity one-on-one, founded on trust and
                    confidence and typically takes hourly sessions over a 48
                    weeks. Progress is monitored, evaluated and reported on
                    monthly basis.
                  </p>
                  <h3 className="text-xl font-semibold">Step 02</h3>
                </div>
                <div className="self-center h-3 w-3 items-center  rounded-full bg-secondary-dark " />
                <MdLocationPin
                  size={100}
                  className="rotate-180  transform -translate-y-[260%]"
                />
              </li>
              <li className="text-left  grid grid-cols-1 place-items-center  auto-rows-fr text-primary-dark">
                <MdLocationPin
                  size={100}
                  className=" transform translate-y-[260%]"
                />
                <div className="self-center h-3 w-3 items-center  rounded-full bg-secondary-dark " />
                <div className=" rounded p-3  flex flex-col gap-2  transform -translate-y-[80%]">
                  <h3 className="text-xl font-semibold">Step 03</h3>

                  <p>
                    The Mentee finds a trusted and resourceful mentor who helps
                    them to come into their own. The journey from mentee to a
                    young Maven covers criticla aspects such as self belief,
                    purpose, coping with stress, ethno-cultural identity,
                    persistence, careers, community involvement among many
                    others.
                  </p>
                </div>
              </li>
              <li className="text-left  grid grid-cols-1 place-items-center  auto-rows-fr text-secondary-dark">
                <div className=" rounded p-3  flex flex-col gap-2   transform translate-y-[190%]">
                  <p>
                    At the end of the year a graduation and celebrations event
                    is held to mark the coming out of the new mavens.
                  </p>
                  <h3 className="text-xl font-semibold">Step 04</h3>
                </div>
                <div className="self-center h-3 w-3 items-center  rounded-full bg-secondary-dark " />
                <MdLocationPin
                  size={100}
                  className="rotate-180  transform -translate-y-[260%]"
                />
              </li>
            </ul>
          </div>
        </div>

        {/* Trial timeline -mobile */}
        <div className="block xl:hidden">
          <VerticalTimeline>
            <VerticalTimelineElement
              className="vertical-timeline-element--work"
              contentStyle={{
                background: "none",
                border: "none",
                boxShadow: "none",
              }}
              textClassName="text-secondary-dark"
              contentArrowStyle={{ borderRight: "20px solid  #ffbf00" }}
              // date="2011 - present"
              iconStyle={{
                background: "#820000",
                color: "#fff",
              }}
            >
              <div className="rounded  flex flex-col gap-2 ">
                {/* <h3 className="text-xl font-semibold">Step 01</h3> */}
                <p>
                  Using research-proven, global best practice we train our
                  Mentors who are themselves experts or Mavens in different
                  fields. The training rarely takes less than a full week. Using
                  this knowledge each Maven enters into a mentoring relationship
                  with a teen.
                </p>
              </div>
            </VerticalTimelineElement>
            <VerticalTimelineElement
              className="vertical-timeline-element--work"
              contentStyle={{
                background: "none",
                border: "none",
                boxShadow: "none",
              }}
              contentArrowStyle={{ borderRight: "20px solid  #e8ecd9" }}
              iconStyle={{
                background: "#820000",
                color: "#fff",
              }}
              textClassName="text-accent-dark"
            >
              <div className="rounded p-3 flex flex-col gap-2">
                {/* <h3 className="text-xl font-semibold">Step 02</h3> */}
                <p>
                  The journey is of necessity one-on-one, founded on trust and
                  confidence and typically takes hourly sessions over a 48
                  weeks. Progress is monitored, evaluated and reported on
                  monthly basis.
                </p>
              </div>
            </VerticalTimelineElement>

            <VerticalTimelineElement
              className="vertical-timeline-element--work"
              contentStyle={{
                background: "none",
                border: "none",
                boxShadow: "none",
              }}
              contentArrowStyle={{ borderRight: "20px solid  #820000" }}
              // date="2011 - present"
              iconStyle={{
                background: "#820000",
                color: "#fff",
              }}
              textClassName="text-primary-dark"
            >
              <div className=" rounded p-3  flex flex-col gap-2  ">
                {/* <h3 className="text-xl font-semibold">Step 03</h3> */}

                <p>
                  The Mentee finds a trusted and resourceful mentor who helps
                  them to come into their own. The journey from mentee to a
                  young Maven covers criticla aspects such as self belief,
                  purpose, coping with stress, ethno-cultural identity,
                  persistence, careers, community involvement among many others.
                </p>
              </div>
            </VerticalTimelineElement>
            <VerticalTimelineElement
              className="vertical-timeline-element--work"
              contentStyle={{
                background: "none",
                border: "none",
                boxShadow: "none",
              }}
              contentArrowStyle={{ borderRight: "20px solid   #ffbf00" }}
              iconStyle={{
                background: "#820000",
                color: "#fff",
              }}
              textClassName="text-secondary-dark"
            >
              <div className=" rounded p-3  flex flex-col gap-2">
                {/* <h3 className="text-xl font-semibold">Step 04</h3> */}
                <p>
                  At the end of the year a graduation and celebrations event is
                  held to mark the coming out of the new mavens.
                </p>
              </div>
            </VerticalTimelineElement>
          </VerticalTimeline>
        </div>
      </main>
    </div>
  );
};

export default MavenJourneyPage;
