import { NewsCard } from "components/home/NewsSection";
import LayoutThree from "components/layout/LayoutThree";
import Calendar from "components/shared/Calendar";
import { INews } from "data";
import { events, news } from "dummyData";
import { NextPageContext } from "next";
import Image from "next/image";
import { NextPageWithLayout } from "pages/_app";
import { ReactElement } from "react";
import Slider from "react-slick";

import "slick-carousel/slick/slick-theme.css";
import "slick-carousel/slick/slick.css";

interface IProps {
  newsItem: INews;
}

const MentorEnrollPage: NextPageWithLayout<IProps> = ({ newsItem }) => {
  if (!newsItem) {
    return <div>News Item not found</div>;
  }

  const settings = {
    dots: false,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    pauseOnHover: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: false,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <div className="">
      <section className="w-[80%] mx-auto ">
        <div className="container mx-auto px-4">
          <div className="lg:col-gap-12 xl:col-gap-16 mt-8 grid grid-cols-1 gap-12 lg:mt-12 lg:grid-cols-5 lg:gap-16 ">
            <div className="lg:col-span-4 lg:row-end-1 ">
              <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp pb-10 flex items-center gap-3">
                Overview
                {/* <span className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
                  <Image src={"/logom4.png"} layout="fill" />
                </span> */}
              </h3>
              <div className="lg:flex lg:items-start relative flex-col gap-2">
                <div className="text-base sm:text-xl lg:text-2xl xl:text-3xl   font-bold text-primary-dark">
                  The Maven Mentor will seek to be a change agent. They will
                  recognize the power of voluntarism and the potential of youth
                  in a continent that holds incredible promise. The Maven Mentor
                  will embrace the enduring nature of the mentor mentee
                  relationship and diligently avail the time required.
                </div>
                <div className="text-base sm:text-xl lg:text-2xl xl:text-3xl  text-light-dark">
                  Training is conducted regularly. The Maven Mentor will be
                  trained in discussion techniques that build strong, trustful
                  relationships. Most interactions will be discussions. The
                  discussion techniques will be respectful, enabling, and
                  youth-centred. The Maven Mentor will be trained in employing
                  open ended questions and active listening. The Maven Mentor
                  will also be trained to demonstrate empathy, warmth and
                  authenticity in the relationship.
                </div>
                <div className="text-base sm:text-xl lg:text-2xl xl:text-3xl   font-semibold text-primary-dark">
                  The Maven Mentor will be trained to recognize and appreciate
                  patterns of cultural difference and to seek opportunities to
                  build self awareness, understanding and appreciation of other
                  cultures. A monthly monitoring and evaluation framework
                  provides quality assurance to all stakeholders. Download the
                  application form below and submit it to{" "}
                  <span className="text-blue-500 cursor-pointer">
                    <a href="mailto:info@mavenmentorship.org">
                      info@mavenmentorship.org
                    </a>
                  </span>
                  .
                </div>
                <div className="bg-primary-dark border border-primary-dark absolute top-0 right-0 h-full transform translate-x-4"></div>
              </div>
              <button className="rounded-lg bg-primary-dark w-fit p-3 mt-10">
                <a
                  className="text-accent-dark text-xl font-semibold"
                  href="/forms/mentors-form.pdf"
                  download
                >
                  Download Form
                </a>
              </button>
            </div>

            <div className="lg:col-span-2 lg:row-span-2 lg:row-end-2">
              <h3 className="mb-5 text-xl">
                Events
                <span className="border-b-2 border-b-primary-dark block mt-1 w-[20%]"></span>
              </h3>
              {events.map((event) => (
                <div className="flex gap-2 pb-4" key={event.id.toString()}>
                  <Calendar
                    day={event.date?.month}
                    year={event?.date?.year}
                    invert
                  />
                  <div className="flex flex-col justify-center gap-1">
                    <h4 className="text-light-dark text-xl font-semibold line-clamp-2">
                      {event.title}
                    </h4>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>

        <div className="mt-8  w-full min-h-[20vh] py-20">
          <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp pb-10 flex items-center gap-3">
            Other News
            <span className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
              <Image src={"/logom4.png"} layout="fill" />
            </span>
          </h3>
          <Slider {...settings} className="-mx-4">
            {news.map((newsItem) => (
              <NewsCard newsItem={newsItem} />
            ))}
          </Slider>
        </div>
      </section>
    </div>
  );
};

export default MentorEnrollPage;

MentorEnrollPage.getInitialProps = ({ query }: NextPageContext): IProps => {
  // const { newsId } = query;
  const newsItem = news.find((n) => n.id === Number(1));

  return {
    newsItem: newsItem as INews,
  };
};

MentorEnrollPage.getLayout = function getLayout(page: ReactElement) {
  const { props } = page;

  return (
    <LayoutThree image="/mentorbg.jpeg" title={"Become a mentor"}>
      {page}
    </LayoutThree>
  );
};
