import LayoutTwo from "components/layout/LayoutTwo";
import { mentorshipProgrammes } from "dummyData";
import Image from "next/image";
import { ReactElement } from "react";

const MentorshipProgrammesPage = () => {
  return (
    <div className="py-10  bg-accent-dark">
      <main className="w-[80%] mx-auto">
        <div className="flex flex-row sm:items-center sm:text-3xl gap-4 font-semibold tracking-normal">
          <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp">
            Our Mentorship Programmes
          </h3>
          <div className="flex items-center gap-3">
            <div className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
              <Image src={"/logom4.png"} layout="fill" />
            </div>
            {/* <Link href="#.">
              <a className="uppercase text-secondary-accent font-cmp text-2xl sm:text-4xl">
                More on our programmes
              </a>
            </Link> */}
          </div>
        </div>

        <div className="pt-[4%]">
          {mentorshipProgrammes.map((programme, idx) => {
            const order = (idx + 3) % 2;

            return (
              <section
                className="min-h-[70vh] mx-auto flex flex-col gap-4 pb-14"
                id={programme.title.toLowerCase().split(" ").join("-")}
                key={programme.id.toString()}
              >
                <article
                  className={`flex flex-1 flex-col ${
                    order == 1 ? "md:flex-row" : "md:flex-row-reverse"
                  } w-full gap-10 `}
                >
                  <div
                    className={`md:w-1/3 flex flex-col py-5 gap-10 text-xl text-primary-dark `}
                  >
                    <h2 className="font-semibold uppercase text-2xl">
                      {programme.title}
                    </h2>
                    <p className="font-semibold">{programme.intro}</p>
                    <p>{programme.body}</p>
                  </div>

                  {/* image card */}
                  <div className=" w-full md:w-[60%]">
                    <div className="relative w-full h-[30vh] md:h-[80%]">
                      <Image
                        layout="fill"
                        src={programme.image}
                        objectFit="cover"
                      />
                    </div>
                    <div className="flex flex-col md:flex-row md:items-center justify-between p-4 gap-5"></div>
                  </div>
                </article>
              </section>
            );
          })}
        </div>
      </main>
    </div>
  );
};

export default MentorshipProgrammesPage;

MentorshipProgrammesPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo
      image={"/mentorship-programmes-bg.jpeg"}
      title={"Mentorship Programmes"}
    >
      {page}
    </LayoutTwo>
  );
};
