import LayoutThree from "components/layout/LayoutThree";
import { partnerActivities, team } from "dummyData";
import Image from "next/image";
import Link from "next/link";
import { ReactElement } from "react";
import { BsPeopleFill } from "react-icons/bs";
import { HiCalendar } from "react-icons/hi";
import { ImLocation2 } from "react-icons/im";
import { TiTick } from "react-icons/ti";
import Slider from "react-slick";
import "slick-carousel/slick/slick-theme.css";
import "slick-carousel/slick/slick.css";

const PartnersPage = () => {
  const settings = {
    dots: false,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    autoplay: true,
    autoplaySpeed: 3000,
    pauseOnHover: true,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
          infinite: true,
          dots: false,
        },
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 2,
          initialSlide: 2,
        },
      },
      {
        breakpoint: 480,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        },
      },
    ],
  };

  return (
    <div className="">
      <section className="w-[80%] mx-auto ">
        <div className="container mx-auto px-4">
          <div className="lg:col-gap-12 xl:col-gap-16 mt-8 grid grid-cols-1 gap-12 lg:mt-12 lg:grid-cols-5 lg:gap-16 ">
            <div className=" lg:row-span-2 lg:row-end-2">
              {/* <h3 className="mb-5 text-xl">
                Event details
                <span className="border-b-2 border-b-primary-dark block mt-1 w-[20%]"></span>
              </h3> */}

              {/* Where */}
              <div className="flex gap-2 pb-4 lg:pt-20 pt-0">
                <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white">
                  <ImLocation2 size={20} />
                </div>
                <div className="flex flex-col justify-center gap-1">
                  <h4 className="text-light-dark text-xl font-semibold line-clamp-2">
                    Where
                  </h4>
                  <h5 className="text-light-accent text-base font-semibold line-clamp-2">
                    {/* {event.venue} */}
                    Nairobi, Kenya.
                  </h5>
                </div>
              </div>

              {/* When */}
              <div className="flex gap-2 pb-4">
                <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white">
                  <HiCalendar size={20} />
                </div>
                <div className="flex flex-col justify-center gap-1">
                  <h4 className="text-light-dark text-xl font-semibold line-clamp-2">
                    When
                  </h4>
                  <h5 className="text-light-accent text-base font-semibold line-clamp-2">
                    {/* {event.date && Object.values(event.date).join(" ")} */}
                    24/7/365
                  </h5>
                </div>
              </div>

              {/* Capacity */}
              <div className="flex gap-2 pb-4">
                <div className="rounded-lg px-4 py-3 bg-primary-dark flex items-center justify-center text-white">
                  <BsPeopleFill size={20} />
                </div>
                <div className="flex flex-col justify-center gap-1">
                  <h4 className="text-light-dark text-xl font-semibold line-clamp-2">
                    Partners
                  </h4>
                  {/* <h5 className="text-light-accent text-base font-semibold line-clamp-2 ">
                    100+
                  </h5> */}
                </div>
              </div>
            </div>
            <div className="lg:col-span-4 lg:row-end-1 ">
              <h2 className="text-primary-dark text-4xl sm:text-5xl font-cmp pb-10">
                Overview
                {/* <span className="border-b-2 border-b-primary-dark block mt-1 w-[20%]"></span> */}
              </h2>
              <div className="lg:flex lg:items-start relative flex-col gap-2">
                <p className="text-base sm:text-xl lg:text-2xl xl:text-3xl   font-bold text-primary-dark">
                  We are driven by a dedication expressed through voluntarism
                  but actively supported by partnerships. Our vision of helping
                  transformation of African youth and their future vis a vis the
                  sheer size of the need means that Outreach is at the very
                  heart of our work.
                </p>
                <p className="text-base sm:text-xl lg:text-2xl xl:text-3xl  text-light-dark">
                  The effectiveness of our outreach programme is intertwined
                  with resources that can be mobilized by us and our partners.
                  We welcome both interest and partnership agreement. Please
                  contact our Cofounder & Chairman or any Director of our Board
                  by clicking{" "}
                  <a
                    href="mailto:stephenwandera@mavenmentorship.org?subject='Partner With Us'"
                    className="hover:underline text-primary-dark"
                  >
                    here.
                  </a>
                </p>
                <div className="bg-primary-dark border border-primary-dark absolute top-0 left-0 h-full transform -translate-x-14"></div>
              </div>
              <div className="mt-10">
                {/* <h3 className="text-base sm:text-xl lg:text-2xl xl:text-3xl  text-light-dark pb-5">
                 
                </h3> */}
                <h3 className="text-primary-dark text-3xl sm:text-4xl font-cmp pb-10 flex items-center gap-3">
                  What partners can do:
                  <span className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
                    <Image src={"/logom4.png"} layout="fill" />
                  </span>
                </h3>
                <ul>
                  {partnerActivities.map((activity) => (
                    <li className="py-1">
                      <div className="flex items-center space-x-3">
                        <span className="bg-secondary-accent text-primary-dark rounded">
                          <TiTick size={30} />
                        </span>
                        <span className="text-base sm:text-2xl">
                          {activity.title}
                        </span>
                      </div>
                    </li>
                  ))}
                </ul>
              </div>
            </div>
          </div>
        </div>

        <div className="mt-8  w-full min-h-[20vh] py-20">
          <h3 className="text-primary-dark text-4xl sm:text-5xl font-cmp pb-10 flex items-center gap-3">
            Board members
            <span className="relative h-8 sm:h-12 w-3 sm:w-4 flex items-center">
              <Image src={"/logom4.png"} layout="fill" />
            </span>
          </h3>
          <Slider {...settings} className="-mx-4">
            {team.map((member) => (
              <div key={member.id.toString()} className="mx-2 px-4">
                <article className="relative">
                  <Link href={`/board/${member.id}`}>
                    <div className=" aspect-square overflow-hidden container relative group">
                      <Image
                        //   className="h-full w-full "
                        src={`/team/${member.image}`}
                        alt=""
                        layout="fill"
                        className=" object-cover transition-all duration-300 group-hover:scale-110 hover:rounded-lg"
                      />
                      <div className="absolute top-0 left-0 w-full h-full flex flex-col items-center justify-center bg-gradient-to-t  from-[#5e312f] to-[#5e312f63] transform transition-all duration-250 translate-y-full group-hover:translate-y-0">
                        <div className="relative h-16 w-16 mb-10">
                          <Image src={"/favicon.png"} layout="fill" />
                        </div>
                        <h3 className="text-sm font-semibold sm:text-md md:text-xl">
                          <span title={member.name}>
                            <span className="text-secondary-dark">
                              {member.name}
                            </span>
                          </span>
                        </h3>
                        <h3 className="text-sm font-semibold text-white sm:text-md md:text-xl ">
                          <span>More info</span>
                        </h3>
                      </div>
                    </div>
                  </Link>

                  <div className="mt-4 flex items-start justify-between">
                    <div className="text-center w-full">
                      <h3 className="font-semibold text-base md:text-xl">
                        <Link href={"#."}>
                          <a title="">
                            <span className="text-primary-dark">
                              {member.name}
                            </span>
                          </a>
                        </Link>
                      </h3>
                      <h4>
                        <span
                          className="text-xs  sm:text-sm md:text-base block line-clamp-2"
                          aria-hidden="true"
                        >
                          {member.profession}
                        </span>
                      </h4>
                    </div>
                  </div>
                </article>
              </div>
            ))}
          </Slider>
        </div>
      </section>
    </div>
  );
};

export default PartnersPage;

// PartnersPage.getInitialProps = ({ query }: NextPageContext): IProps => {
//   const { eventId } = query;
//   const event = events.find((event) => event.id === Number(eventId));

//   return {
//     event: event as IEvent,
//   };
// };

PartnersPage.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutThree
      title="Partner With Us"
      tag="Become a partner"
      email="stephenwandera@mavenmentorship.org"
      image="/partnersbg.jpeg"
    >
      {page}
    </LayoutThree>
  );
};
