import { ProgrammeCard } from "components/home/ProgrammesSection";
import LayoutTwo from "components/layout/LayoutTwo";
import { programmes } from "dummyData";
import { NextPageWithLayout } from "pages/_app";
import { ReactElement } from "react";

const Programmes: NextPageWithLayout = () => {
  return (
    <div className="py-20 bg-accent-dark">
      <main className="w-[80%] mx-auto ">
        <div className="grid gap-x-8 gap-y-10 sm:grid-cols-2 lg:grid-cols-3">
          {programmes.map((programme) => (
            <ProgrammeCard
              key={programme.id.toString()}
              programme={programme}
            />
          ))}
        </div>
      </main>
    </div>
  );
};

export default Programmes;

Programmes.getLayout = function getLayout(page: ReactElement) {
  return (
    <LayoutTwo image="/news/newsbg.jpeg" title="all programmes">
      {page}
    </LayoutTwo>
  );
};
